// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	float iPro = (3.0f* progress * progress - 2.0f * progress * progress * progress); 	
	int width = W;
	float4 outputCol;

	int alpha1 = 0;
	int alpha2 = 255;
	float dScale = iPro;
	float4 y1 = INPUT(input1, param, uv);
	float4 y2 = INPUT(input2, param, uv);
	const int iColWidth = 10 * resolution.y/320.0f; 
	const int iColDouble = iColWidth * 2;
	float4 z;
	int height = H;
	float lowerMatt = step( (float)(gl_FragCoord.y% iColDouble), (float)(iColWidth))* step( uv.x, iPro);  
	float  upperMatt= step( (float)(iColWidth+1), (float)(gl_FragCoord.y % iColDouble))* step(1.0f - iPro, uv.x);  
	outputCol = mix(y1, y2, upperMatt+lowerMatt); 

	write_imagef(dstImg, (int2)(w, textH - h -1), outputCol);
}